#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式
	
	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出
	
	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}


/***************************************************************************************
*  Function  :  DAC_Config  配置DAC
*  Parameters：
*           Vref：参考电压
*                             DAC_VDD    1     //DAC参考电压选择VDD
*                             DAC_FVR    0     //DAC参考电压选择FVR
*           DacMode：DAC抽头选择
*                             DAC_0      0     //Vdac = (1/5)DAC_VREF+[(n+1)/40]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_1      1     //Vdac = [(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_2      2     //VDAC = (1/4)DAC_VREF+[(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_3      3     //Vdac = [(n+1)/24]DAC_VREF, n = DAC[3:0] in decimal
*           Data：输出电压值选择   0 ~ 15
*           state：DAC使能                 
*                             DAC_EN     1     //使能DAC
*                             DAC_DIS    0     //禁止DAC
*
*
******************************************************************************************/

void DAC_Config(unsigned char Vref,unsigned char DacMode,unsigned char Data,unsigned char state)
{
	


	DACCON = 0x00;
	DACCON |= Vref << 7;         //参考电压
	DACCON |= DacMode << 4;      //抽头选择
	DACCON |= Data;              //抽头选择
	DACCON |= state << 6;        //DAC使能

	printf("DAC0CON-0X%02X,\r\n", DACCON);

	DACCLKEN = 1;

}
/*******************************************************************************
 *   Function  :    FVR_Init   FVR配置
 *   Parameters:
 *     FVROUT(输出使能)           
 *                              FVROUT_EN             1    //使能FVR输出         
 *                              FVROUT_DIS            0    //禁止FVR输出 
 *     FVRPGA(电压放大倍数)       
 *                              FVRPGA_1              1    //1倍
 *                              FVRPGA_2              2    //2倍
 *                              FVRPGA_3              3    //3倍
 *     FVR_SEL(FVR电压选择)       
 *                              FVR_SEL_0             0    //PA3         
 *                              FVR_SEL_1             1    //VREF1P0(1.0V)
 *                              FVR_SEL_2             2    //1/4VDD
 *                              FVR_SEL_3             3    //NTC
 *                              FVR_SEL_4             4    //DACOUT
 *                              FVR_SEL_5             5    //TCKS(仅内部使用）
 *                              FVR_SEL_6             6    //BGR_OUT（仅内部使用）
 *                              FVR_SEL_7             7    //VLCD（仅内部使用）
 *     FVROFFSET(校准使能)
 *                              FVR_OFFSET_EN         1    //允许使能 
 *                              FVR_OFFSET_DIS        0    //禁止使能
 *     FVR_TRIM(校准值)          0~31
 * *********************************************************************************/

void FVR_Init(unsigned char FVROUT,unsigned char FVRPGA,unsigned char FVR_SEL,unsigned char FVROFFSET,unsigned char FVR_TRIM)
{
	FVRCON0 = 0X00;
	FVRCON0 |= FVROUT << 6;
	FVRCON0 |= FVRPGA << 3;
	FVRCON0 |= FVR_SEL ;
	FVRCON0 |= 1 << 5;

	if (FVROFFSET == FVR_OFFSET_EN)
	{
		FVRCON1 = 0X00;
		FVRCON1 |= FVROFFSET << 5;
		FVRCON1 |= FVR_TRIM;
	}	
}
